#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
/* Compliant                                                 */
extern int16_t func1 ( int16_t n );

/* Non-compliant - parameter name not specified              */
extern void func2 ( int16_t );

/* Non-compliant - not in prototype form                     */
static int16_t func3 ( );

/* Compliant                                                 */
static int16_t func4 ( void );

/* Compliant                                                 */
int16_t func1 ( int16_t n )
{
  return n;
}

/* Non-compliant - old style identifier and declaration list */
static int16_t func3 ( vec, n )
int16_t *vec;
int16_t n;
{
  return vec[ n - 1 ];
}

/* Non-compliant - no prototype                              */
int16_t ( *pf1 ) ( );

/* Compliant                                                 */
int16_t ( *pf1 ) ( void );

/* Non-compliant - parameter name not specified              */
typedef int16_t ( *pf2_t ) ( int16_t );

/* Compliant                                                 */
typedef int16_t ( *pf3_t ) ( int16_t n );
// Example code from MISRA C:2012 end
